
close all
%Constants
Sigma_S=5;
Mean_S=35;

input_image=imread('brainmri.JPG');
figure(1);
image(input_image);
Gray_image=rgb2gray(input_image);

figure(2);
% Displaying original Gray image
imshow(Gray_image);

% image histogram 
imag_hst=imhist(Gray_image);
figure(3);
plot(imag_hst);

%Max no pixel will have a lower gray scale vcalue since they r in
%background and background in MRI images is generally black
%u can observe it in histogram


%As per the algorithm Generally, the first peak ends at approximately 5% of the maximum intensity of the image
%So first finding the max intensity in the image

Max_Intensity=max(max(Gray_image));
;
%  we are finding the 10% of the max intensity.
 % To improve accuracy, this percentage needs to be adjusted interactively

treshold=0.1*Max_Intensity;

%Now according to the algorithm these pixels lesser t5han 10%of max value
%have to be excluded from the standardisation process

 Except_background=find(  (Gray_image>=treshold) );
 
 
%now this is the histogram after removal of background informn
New_imag_hst=imhist(Gray_image( Except_background));


%this is the indices of the pixels after removal of background informn
%as per algorithm performing mean and SD on this image
Mean_Image=mean(Gray_image( Except_background));
Std_Dev_Image=std(Gray_image( Except_background));

Output_Image=Gray_image;               % copy iput to output

% After performing the mean and SD on the image excluding the background
% information we are adding the background informn backinto the image
Output_Image( Except_background)=(Sigma_S /Std_Dev_Image)* (Gray_image( Except_background)-Mean_Image) + Mean_S ;

figure(4);
imshow(Output_Image);

figure(5);
plot(New_imag_hst);
